function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 111);

T(1) = (params(2)-1)/params(2);
T(2) = (1-params(11))*exp(T(1)*y(48));
T(3) = exp(y(13))^params(3);
T(4) = exp(y(43));
T(5) = T(4)^(1-params(3));
T(6) = T(3)*T(5);
T(7) = T(6)^T(1);
T(8) = exp(y(40));
T(9) = T(2)*T(7)+params(11)*T(8)^T(1);
T(10) = params(2)/(params(2)-1);
T(11) = 1/params(2);
T(12) = exp(y(41))^T(11);
T(13) = (-1)/params(2);
T(14) = T(8)^T(13);
T(15) = T(12)*exp(T(1)*y(48))*(1-params(11))*(1-params(3));
T(16) = T(6)^T(13);
T(17) = T(4)^(-params(3));
T(18) = T(12)*exp(T(1)*y(48))*(1-params(11))*params(3);
T(19) = exp(y(13))^(params(3)-1);
T(20) = exp(y(42));
T(21) = params(9)^((-1)/params(8));
T(22) = 1/params(8);
T(23) = exp(y(109));
T(24) = exp(y(47));
T(25) = exp(y(44))-params(9)*T(4)^(1+params(8))/(1+params(8));
T(26) = T(25)^(-params(14));
T(27) = exp(y(15))-params(9)*exp(y(14))^(1+params(8))/(1+params(8));
T(28) = T(27)^(-params(14));
T(29) = params(13)^(1-params(4));
T(30) = params(24)^(1-params(4));
T(31) = params(12)^(1-params(4));
T(32) = T(26)*exp(y(26))*exp(y(29));
T(33) = params(25)^(-1);
T(34) = T(33)*y(20)*(-(T(24)*exp(y(26))*exp(y(11))));
T(35) = T(33)*y(23)*(-(T(24)*exp(y(26))*exp(y(54))));
T(36) = y(79)*(-exp(y(26)))+exp(y(26))*y(65)+T(34)+T(33)*y(22)*(-(exp(y(26))*T(24)))+T(35);
T(37) = exp(y(26))*exp(y(29))-exp(y(29))*params(6)*exp(y(63)-y(49))^(params(5)-1);
T(38) = params(25)*y(129)*(-(exp(y(31))*exp((-y(111)))*exp(y(35))));
T(39) = exp(y(31))*y(82)+params(25)*y(119)*exp(y(31))*params(6)*exp(params(5)*y(35))+params(25)*y(123)*(-(exp(y(31))*(1-exp((-y(111)))*exp(y(35)))))+T(38);
T(40) = params(25)*y(127)*(-(exp(y(36))*exp(y(32))));
T(41) = exp(y(32))*y(80)+params(25)*y(119)*params(6)*exp(params(5)*y(36))*exp(y(32))+params(25)*y(121)*(-((1-exp(y(36)))*exp(y(32))))+T(40);
T(42) = exp(y(33))*y(85)+y(82)*(-(params(7)*exp(y(33))))+params(25)*y(126)*(-((1-params(7))*exp(y(33))));
T(43) = exp(y(34))*y(83)+y(80)*(-(params(7)*exp(y(34))))+params(25)*y(124)*(-((1-params(7))*exp(y(34))));
T(44) = params(25)*y(123)*(-(exp(y(31))*(-(exp((-y(111)))*exp(y(35))))));
T(45) = T(38)+params(25)*y(119)*exp(y(31))*params(6)*params(5)*exp(params(5)*y(35))+T(44);
T(46) = T(23)*params(6)*params(5)*(params(5)-1)*exp(y(36)*(params(5)-1));
T(47) = (-(T(23)*(exp(y(36))*exp(y(101))+y(102)*(-exp(y(36)))-params(6)*params(5)*exp(params(5)*y(36)))));
T(48) = params(25)*y(121)*(-(exp(y(32))*(-exp(y(36)))));
T(49) = T(8)*getPowerDeriv(T(8),T(13),1);
T(50) = T(8)*getPowerDeriv(T(8),T(1),1);
T(51) = getPowerDeriv(T(9),T(10),1);
T(52) = exp(y(41))*getPowerDeriv(exp(y(41)),T(11),1);
T(53) = exp(T(1)*y(48))*(1-params(11))*params(3)*T(52);
T(54) = exp(T(1)*y(48))*(1-params(11))*(1-params(3))*T(52);
T(55) = (1-params(11))*exp(T(1)*y(110));
T(56) = exp(y(106))^(1-params(3));
T(57) = T(20)*getPowerDeriv(T(20),params(3),1);
T(58) = T(20)^params(3);
T(59) = T(56)*T(58);
T(60) = getPowerDeriv(T(59),T(1),1);
T(61) = T(55)*T(56)*T(57)*T(60);
T(62) = T(59)^T(1);
T(63) = T(55)*T(62)+params(11)*exp(y(104))^T(1);
T(64) = getPowerDeriv(T(63),T(10),1);
T(65) = exp(y(106))^(-params(3));
T(66) = exp(y(105))^T(11);
T(67) = T(66)*(1-params(11))*(1-params(3))*exp(T(1)*y(110));
T(68) = T(59)^T(13);
T(69) = getPowerDeriv(T(59),T(13),1);
T(70) = T(56)*T(57)*T(69);
T(71) = T(20)^(params(3)-1);
T(72) = T(66)*(1-params(11))*params(3)*exp(T(1)*y(110));
T(73) = T(20)*getPowerDeriv(T(20),params(3)-1,1);
T(74) = (-(T(56)*(T(71)*T(70)*T(72)+T(68)*T(72)*T(73))));
T(75) = T(4)*getPowerDeriv(T(4),1+params(8),1);
T(76) = (-(params(9)*T(75)/(1+params(8))));
T(77) = getPowerDeriv(T(25),(-params(14)),1);
T(78) = T(76)*T(77);
T(79) = (1-params(3))*exp(y(43)*(1-params(3)));
T(80) = (-(exp(T(1)*y(48))*exp(y(13)*params(3))*T(79)));
T(81) = T(4)*getPowerDeriv(T(4),1-params(3),1);
T(82) = getPowerDeriv(T(6),T(13),1);
T(83) = T(3)*T(81)*T(82);
T(84) = (-(T(16)*T(18)*T(19)*T(81)+T(5)*T(19)*T(18)*T(83)));
T(85) = T(4)*getPowerDeriv(T(4),(-params(3)),1);
T(86) = (-(T(17)*T(3)*T(15)*T(83)+T(3)*T(15)*T(16)*T(85)));
T(87) = getPowerDeriv(T(6),T(1),1);
T(88) = T(2)*T(3)*T(81)*T(87);
T(89) = exp(y(107))-params(9)*exp(y(106))^(1+params(8))/(1+params(8));
T(90) = params(1)*T(89)^(-params(14));
T(91) = exp(y(44))*T(77);
T(92) = (-(params(1)*T(91)/T(28)));
T(93) = exp(y(46))*getPowerDeriv(exp(y(46)),T(22),1);
T(94) = T(33)*y(22)*(T(24)*params(6)*params(5)*exp(y(11)*(params(5)-1))-T(24)*(exp(y(26))-y(38)))+T(24)*y(71)+T(33)*y(19)*(-(T(24)*(1+exp(y(45))-params(10))))+T(33)*y(20)*(-(T(24)*(exp(y(26))*exp(y(11))+y(38)*(1-exp(y(11)))-params(6)*exp(params(5)*y(11)))))+T(33)*y(21)*(-(y(39)*T(24)*(1-params(7))))+T(33)*y(23)*(-(T(24)*(exp(y(26))*exp(y(54))+y(55)*(1-exp(y(54)))-params(22)*exp(params(21)*y(54)))))+T(33)*y(24)*(-(y(56)*T(24)*(1-params(23))));
T(95) = T(12)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(48));
T(96) = T(12)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(48));
T(97) = (1-params(11))*T(1)*exp(T(1)*y(48));
T(98) = T(7)*T(97);
T(99) = params(25)^2;
T(100) = getPowerDeriv(exp(y(63)-y(49)),params(5)-1,1);
T(101) = (-(exp(y(29))*params(6)*(-exp(y(63)-y(49)))*T(100)));
T(102) = T(26)*T(101);
T(103) = (-(exp(y(6))*exp(y(10))*(-exp((-y(49))))));
T(104) = (-(exp(y(6))*(-(exp(y(10))*(-exp((-y(49))))))));
T(105) = y(88)*T(103)+y(82)*T(104);
T(106) = exp(y(52))*y(81)+params(25)*y(119)*params(22)*exp(params(21)*y(112))*exp(y(52))+params(25)*y(122)*(-((1-exp(y(112)))*exp(y(52))))+params(25)*y(128)*(-(exp(y(112))*exp(y(52))));
T(107) = exp(y(53))*y(84)+y(81)*(-(params(23)*exp(y(53))))+params(25)*y(125)*(-((1-params(23))*exp(y(53))));
T(108) = (-(exp(y(17))*exp(y(54))));
T(109) = (-(exp(y(17))*(-exp(y(54)))));
T(110) = T(33)*y(23)*(-(T(24)*(exp(y(26))*exp(y(54))+y(55)*(-exp(y(54)))-params(22)*params(21)*exp(params(21)*y(54)))));
T(111) = (-(exp(y(29))*params(6)*exp(y(63)-y(49))*T(100)));

end
